library(JGL)

df <- read.csv("generated_samples.csv", row.names = 1, header = TRUE, stringsAsFactors = FALSE, dec = ".")
num.genes <- dim(df)[2] - 1

normal <- scale(df[df["classes"] == "normal", 1:num.genes])
stagei <- scale(df[df["classes"] == "stagei", 1:num.genes])
stageii <- scale(df[df["classes"] == "stageii", 1:num.genes])
stageiii <- scale(df[df["classes"] == "stageiii", 1:num.genes])
stageiv <- scale(df[df["classes"] == "stageiv", 1:num.genes])

cat("Normal and StageI... \n")
fgl.results.stagei <- JGL(
  Y = list(data.matrix(normal), data.matrix(stagei)),
  penalty = "fused", lambda1 = .25, lambda2 = 0.0,
  weights = "equal", return.whole.theta = TRUE, screening = "memory.efficient"
)
save.image("group_lasso_results1.RData")

cat("Normal and StageII... \n")
fgl.results.stageii <- JGL(
  Y = list(data.matrix(normal), data.matrix(stageii)),
  penalty = "fused", lambda1 = .25, lambda2 = 0.0,
  weights = "equal", return.whole.theta = TRUE, screening = "memory.efficient"
)
save.image("group_lasso_results2.RData")

cat("Normal and StageIII... \n")
fgl.results.stageiii <- JGL(
  Y = list(data.matrix(normal), data.matrix(stageiii)),
  penalty = "fused", lambda1 = .25, lambda2 = 0.0,
  weights = "equal", return.whole.theta = TRUE, screening = "memory.efficient"
)
save.image("group_lasso_results3.RData")

cat("Normal and StageIV... \n")
fgl.results.stageiv <- JGL(
  Y = list(data.matrix(normal), data.matrix(stageiv)),
  penalty = "fused", lambda1 = .25, lambda2 = 0.0,
  weights = "equal", return.whole.theta = TRUE, screening = "memory.efficient"
)

save.image("group_lasso_results4.RData")
