import sys

import networkx as nx
import pandas as pd
from pgmpy.models import MarkovModel
from pgmpy.readwrite import XMLBIFReader


def to_markov(bifxml, output):
    reader = XMLBIFReader(bifxml)
    model = reader.get_model()

    print("Directed model")
    print("Number of nodes: {}".format(len(model.nodes())))
    print("Number of edges: {}".format(len(model.edges())))

    markov = model.to_markov_model()
    assert markov.check_model() is True

    G = nx.Graph()
    for e in markov.edges():
        G.add_edge(e[0], e[1])

    print("Undirected model")
    print("Number of nodes: {}".format(len(G.nodes())))
    print("Number of edges: {}".format(len(G.edges())))

    nx.write_graphml(G, output)


def get_independencies(graphml, annotation, y, v):
    df = pd.read_csv(annotation)
    gene_names = dict(df.iloc[:, [0, 1]].values)
    G = nx.read_graphml(graphml)
    mm = MarkovModel()
    nodes = {n[0]: gene_names[n[1]["name"]] for n in list(G.nodes(data=True))}
    edges = [(nodes[e[0]], nodes[e[1]]) for e in G.edges()]
    mm.add_nodes_from(nodes.values())
    mm.add_edges_from(edges)

    for i in mm.get_local_independencies().independencies:
        event1, event2, event3 = i.get_assertion()
        x, event2, event3 = list(event1)[0], list(event2), list(event3)
        if x == "ZEB1":
            if y in event2:
                print(event3)


if __name__ == "__main__":
    to_markov(sys.argv[1], sys.argv[2])
    get_independencies(sys.argv[1], sys.argv[2], sys.argv[3], sys.argv[4])
