import sys

import networkx as nx
import pandas as pd


def combine_networks(graph1, graph2, edgelist, outname):
    """Merges graph1 and graph2 and adds edges in edgelist

    :param graph1: str
    :param graph2: str
    :param edgelist: str
    :param outname: str
    :returns: None
    :rtype: None

    """
    G = nx.read_graphml(graph1)
    H = nx.read_graphml(graph2)
    edgelist = pd.read_csv(edgelist, sep="\t")

    M = nx.compose(G, H)
    for e in edgelist.iterrows():
        e = e[1]
        print("Adding {} - {}".format(e[0], e[2]))
        M.add_edge(e[0], e[2])

    print("Writing output graph to a file...")
    nx.write_graphml(M, outname)


def relabel_nodes(graphml, path):
    """relabel nodes ids with its name and save as edgelist

    :param graphml: path of graphml
    :param path: path of output edgelist
    :returns: edgelist
    :rtype: None

    """
    G = nx.read_graphml(graphml)
    mapping = dict([(n[0], n[1]["name"]) for n in G.nodes(data=True)])
    Gprime = nx.relabel_nodes(G, mapping, True)

    nx.write_edgelist(Gprime, path, data=False)
